// /** @type {import('next').NextConfig} */
// const nextConfig = {
//   images: {
//     domains: ["firebasestorage.googleapis.com"],
//   },
// };

// export default nextConfig;

/** @type {import('next').NextConfig} */
const nextConfig = {
  poweredByHeader: false, // ✅ Disables X-Powered-By header

  images: {
    domains: ["firebasestorage.googleapis.com", "niligallery.com"],
  },
  async redirects() {
    return [
      {
        source: "/:path*",
        has: [
          {
            type: "host",
            value: "www.niligallery.com",
          },
        ],
        destination: "https://niligallery.com/:path*",
        permanent: true,
      },
    ];
  },
};

export default nextConfig;
